<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
      <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e($image_logo->company_name ?? ''); ?> | Password Reset </title>
     <?php if($image_logo->favicon_img!=''): ?>
    <link rel="shortcut icon" href="<?php echo e(asset(config('constants.FAVICON_FOLDER_PATH') .'/'. $image_logo->favicon_img)); ?>" >
    <?php endif; ?>

    <!-- Bootstrap -->
    <link href="<?php echo e(asset('assets/admin/vendors/bootstrap/dist/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="<?php echo e(asset('assets/admin/vendors/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">
    <!-- NProgress -->
    <link href="<?php echo e(asset('assets/admin/vendors/nprogress/nprogress.css')); ?>" rel="stylesheet">
    <!-- Animate.css -->
    <link href="<?php echo e(asset('assets/admin/vendors/animate.css/animate.min.css')); ?>" rel="stylesheet">

    <!-- Custom Theme Style -->
    <link href="<?php echo e(asset('assets/admin/build/css/custom.min.css')); ?>" rel="stylesheet">
       <script>
        window.Laravel = <?php echo json_encode([
            'csrfToken' => csrf_token(),
        ]); ?>
    </script>
  </head>

  <body class="login">
    <div>
      <a class="hiddenanchor" id="signup"></a>
      <a class="hiddenanchor" id="signin"></a>

      <div class="login_wrapper">
        <div class="animate form login_form">
          <section class="login_content">
            <form class="form-horizontal" role="form" method="POST" action="<?php echo e(url('/admin/password/reset')); ?>">
                        <?php echo e(csrf_field()); ?>


                        <input type="hidden" name="token" value="<?php echo e($token); ?>">
                <?php if($image_logo->logo_img!=''): ?>
                <img src="<?php echo e(asset(config('constants.LOGO_FOLDER_PATH') .'/'. $image_logo->logo_img)); ?>" style="width: 308px;">
                <?php else: ?>
                <img src="<?php echo e(asset('public/upload/logo.png')); ?>" style="margin-bottom: 20px;">
                <?php endif; ?>
              <h2> Reset Your Account </h2>
              <div class="form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                      <input id="email" type="email" class="form-control" name="email" value="<?php echo e($email ?? old('email')); ?>" autofocus placeholder="Email">

                                <?php if($errors->has('email')): ?>
                                    <span class="help-block text-left">
                                        <strong><?php echo e($errors->first('email')); ?></strong>
                                    </span>
                                <?php endif; ?>
              </div>
             <div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
                    <input id="password" type="password" class="form-control" name="password" placeholder="Password" autocomplete="off">

                                <?php if($errors->has('password')): ?>
                                    <span class="help-block text-left">
                                        <strong><?php echo e($errors->first('password')); ?></strong>
                                    </span>
                                <?php endif; ?>
              </div>
              <div class="form-group<?php echo e($errors->has('password_confirmation') ? ' has-error' : ''); ?>">
                       <input id="password-confirm" type="password" class="form-control" name="password_confirmation" placeholder="Confirm Password" autocomplete="off">

                                <?php if($errors->has('password_confirmation')): ?>
                                    <span class="help-block text-left">
                                        <strong><?php echo e($errors->first('password_confirmation')); ?></strong>
                                    </span>
                                <?php endif; ?>
              </div>

              <div>
                     <button type="submit" class="btn btn-default">
                                 Reset Password
                                </button>
               
              </div>

              <div class="clearfix"></div>

              <div class="separator">
                <div class="clearfix"></div>
                <br />

                <div>
      
                  <p>Legal MIS CRM - ©2022 All Rights Reserved. <br>Tech IT Systems www.techitsys.com</p>
                </div>
              </div>
            </form>
          </section>
        </div>

      </div>
    </div>
  </body>
</html>


